/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.Variant;
import com.borland.jbcl.control.FieldControl;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ImageItemEditor;
import com.borland.jbcl.view.ImageItemPainter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

public class ImageControl
extends FieldControl
implements BlackBox,
Serializable {
    private String imageName;
    private URL url;
    private String boundName;
    private Variant value = new Variant();

    public ImageControl() {
        this.setAlignment(68);
        this.setPreferredHeight(100);
        this.setEditInPlace(false);
        this.defaultLayout();
    }

    protected void defaultLayout() {
        this.setModel(new BasicSingletonContainer());
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new ImageItemPainter(this, this.getAlignment())), new ImageItemEditor()));
    }

    public void setModel(SingletonModel model) {
        if (model == this) {
            throw new IllegalArgumentException(Res._RecursiveModel);
        }
        super.setModel(model);
    }

    public void setImageName(String path) throws IOException {
        if (path != null && !path.equals("")) {
            this.setupImage(ImageLoader.load(path, (Component)this), path);
        } else {
            if (this.isReadOnly()) {
                throw new IllegalStateException(Res._ReadOnlySet);
            }
            this.imageName = null;
            this.getWriteModel().set(null);
        }
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImage(Image image) throws IOException {
        this.setupImage(image, "");
    }

    public Image getImage() {
        Object o = this.getModel().get();
        return o instanceof Image ? (Image)o : null;
    }

    public void setImageURL(URL url) throws IOException {
        this.url = url;
        this.setupImage(ImageLoader.load(url, (Component)this), url.toString());
    }

    public URL getImageURL() {
        return this.url;
    }

    protected void setupImage(Image im, String path) throws IOException {
        Graphics g;
        if (this.isReadOnly()) {
            throw new IllegalStateException(Res._ReadOnlySet);
        }
        this.prepareImage(im, this);
        if ((this.checkImage(im, this) & 0x40) != 0) {
            throw new IOException(Res.bundle.format(22, new String[]{path}));
        }
        this.imageName = path;
        if (this.isVisible() && (g = this.getGraphics()) != null) {
            Rectangle r = this.getInnerRect();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(im);
        }
    }

    public void modelContentChanged(SingletonModelEvent e) {
        Graphics g;
        if (this.isVisible() && (g = this.getGraphics()) != null) {
            Rectangle r = this.getInnerRect();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        super.modelContentChanged(e);
    }

    public boolean imageUpdate(Image im, int flags, int x, int y, int w, int h) {
        if ((flags & 3) != 0) {
            this.invalidate();
        }
        return super.imageUpdate(im, flags, x, y, w, h);
    }

    protected void updateSelection() {
        if (this.getDataSet() != null && this.getColumnName() != null) {
            try {
                this.getDataSet().getVariant(this.getColumnName(), this.value);
                try {
                    Image image = ImageLoader.loadFromBlob(this.value, this, true);
                    this.setupImage(image, "");
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.repaint(100L);
    }
}

