/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StatusEvent;
import com.borland.dx.dataset.StatusListener;
import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.TextControl;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.util.BlackBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class StatusBar
extends BevelPanel
implements NavigationListener,
StatusListener,
AccessListener,
DataSetAware,
BlackBox,
Serializable {
    protected DataSet dataSet;
    protected TextControl label = new TextControl();
    private boolean addNotifyCalled = false;

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.setMargins(new Insets(0, 2, 0, 2));
        this.add((Component)this.label, "Center");
    }

    public int getAlignment() {
        return this.label.getAlignment();
    }

    public void setAlignment(int alignment) {
        this.label.setAlignment(alignment);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeNavigationListener((NavigationListener)this);
            this.dataSet.removeStatusListener((StatusListener)this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addNavigationListener((NavigationListener)this);
            this.dataSet.addStatusListener((StatusListener)this);
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.updateValue();
        }
    }

    public void statusMessage(StatusEvent event) {
        this.setText(event.getMessage());
    }

    public void accessChange(AccessEvent event) {
        switch (event.getID()) {
            case 1: {
                this.updateValue();
                break;
            }
            case 2: {
                this.setText("");
                break;
            }
        }
    }

    public void navigated(NavigationEvent event) {
        this.updateValue();
    }

    protected void updateValue() {
        if (this.dataSet != null && this.dataSet.isOpen()) {
            try {
                if (this.dataSet.getRowCount() > 0) {
                    this.setText(Res.bundle.format(19, Integer.toString(this.dataSet.getRow() + 1), Integer.toString(this.dataSet.getRowCount())));
                } else if (this.dataSet.isEnableInsert() && !this.dataSet.getStorageDataSet().isReadOnly()) {
                    this.setText(Res._EmptyDataSet);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.label.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.label.removeMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.label.addMouseMotionListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.label.removeMouseMotionListener(l);
    }

    public String toString() {
        return this.getText();
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d.width < 200) {
            d.width = 200;
        }
        return d;
    }
}

