/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

public class IntegerTagEditor
implements PropertyEditor {
    int[] values;
    String[] resourceStrings;
    String[] sourceCodeStrings;
    private PropertyChangeListener listener;
    private Object value;

    public IntegerTagEditor(int[] values, String[] resourceStrings, String[] sourceCodeStrings) {
        if (values == null) {
            values = new int[resourceStrings.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = i;
            }
        }
        this.values = values;
        this.resourceStrings = resourceStrings;
        this.sourceCodeStrings = sourceCodeStrings != null ? sourceCodeStrings : resourceStrings;
    }

    public IntegerTagEditor(int[] values, String[] resourceStrings, String[] sourceCodeStrings, boolean sort) {
        this(values, resourceStrings, sourceCodeStrings);
        if (sort) {
            for (int i = 0; i < resourceStrings.length; ++i) {
                for (int j = i + 1; j < resourceStrings.length; ++j) {
                    int compare = resourceStrings[i].compareTo(resourceStrings[j]);
                    if (compare <= 0) continue;
                    String s = resourceStrings[i];
                    resourceStrings[i] = resourceStrings[j];
                    resourceStrings[j] = s;
                    s = sourceCodeStrings[i];
                    sourceCodeStrings[i] = sourceCodeStrings[j];
                    sourceCodeStrings[j] = s;
                    int iVal = values[i];
                    values[i] = values[j];
                    values[j] = iVal;
                }
            }
        }
    }

    public void setValue(Object o) {
        this.value = o;
        this.fire();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    private String getAsText(boolean forSourceCode) {
        int iPos;
        int iVal = this.value == null || !(this.value instanceof Integer) ? this.values[0] : (Integer)this.value;
        for (iPos = 0; iPos < this.values.length && this.values[iPos] != iVal; ++iPos) {
        }
        if (iPos >= this.values.length) {
            return "";
        }
        return forSourceCode ? this.sourceCodeStrings[iPos] : this.resourceStrings[iPos];
    }

    public String getAsText() {
        return this.getAsText(false);
    }

    public String getJavaInitializationString() {
        return this.getAsText(true);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text != null) {
            int iPos;
            for (iPos = 0; iPos < this.resourceStrings.length && !text.equals(this.resourceStrings[iPos]); ++iPos) {
            }
            if (iPos >= this.resourceStrings.length) {
                throw new IllegalArgumentException();
            }
            this.value = new Integer(this.values[iPos]);
            this.fire();
        }
    }

    public String[] getTags() {
        return this.resourceStrings;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "???", null, this.value));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }
}

