/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.UIManager;

public class IntlSwingSupport
implements PropertyChangeListener,
Serializable {
    private transient ResourceBundle res;
    private Locale locale;

    public IntlSwingSupport() {
        this(Locale.getDefault());
    }

    public IntlSwingSupport(Locale locale) {
        try {
            this.res = ResourceBundle.getBundle("com.borland.dbswing.IntlSwingSupportRes");
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return;
        }
        this.setLocale(locale);
        UIManager.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            this.localizeEnvironment();
        }
    }

    private void localizeEnvironment() {
        this.findResourceBundles(UIManager.getLookAndFeel().getClass());
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (locale != null && !Beans.isDesignTime()) {
            this.localizeEnvironment();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void findResourceBundles(Class lookAndFeelClass) {
        if (lookAndFeelClass != null && !lookAndFeelClass.getName().equals("javax.swing.LookAndFeel")) {
            this.findResourceBundles(lookAndFeelClass.getSuperclass());
            try {
                this.loadResourceBundle(this.res.getString(lookAndFeelClass.getName()));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    private void loadResourceBundle(String bundleName) {
        ResourceBundle bundle;
        try {
            bundle = ResourceBundle.getBundle(bundleName, this.locale);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            return;
        }
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            UIManager.put(key, bundle.getObject(key));
        }
    }
}

