/*
 * ABMatrix.java
 *
 * Created on April 4, 2007, 8:34 AM
 *
 * Constraint matrix.
 * 
 */

package csce913proj1;
import java.io.Serializable;

/**
 *
 * @author John R. Hodges
 */
public class ABMatrix implements Serializable {
    /**
     * for Serializable interface
     */
    private static final long serialVersionUID = 5334532903567570727L;
    
    
    /**
     * M is the number of rows and columns since we always have a square matrix
     */
    public int M;
    
    
    /**
     * This is the actual matrix that you must use
     */
    public double[][] matrix;
    
    public ABMatrix() {
        matrix = null;
        M = 0;
    }
    
    /**
     * This loads a previously saved matrix
     * @param filename
     */
    public ABMatrix(double[][] input, int m, String[] variables) throws Exception {
        M = m;
        matrix = input;
        if (m!=variables.length) {
            throw new Exception("The number of variables must match the size of the programs.");
        }
    }
    
    public double[][] getMatrix() {
        return matrix;
    }
    
    public int getM() {
        return M;
    }
    
    // Prints matrix contents
    public void printMatrix() {
        for (int i=0; i<M; i++) {
            for (int j=0; j<M; j++) {
                if (matrix[i][j] == Double.POSITIVE_INFINITY) {
                    System.out.print("---\t");
                } else {
                    System.out.print(matrix[i][j] + "\t");
                }
            }
            System.out.println("");
        }
    }
}

