import java.io.Serializable;

public class CdbTuple implements Serializable {
	
	
	/**
	 * for serialization
	 */
	private static final long serialVersionUID = -8537171694674323049L;

	/**
	 * Represents an addition bound matrix
	 */
	private ABMatrix abm;
	
	/**
	 * names is a list of variable names associated with the rows and columns
	 */
	private String[] names;
	
	/**
	 * The do nothing constructor, you will probably want to write a do 
	 * something constructor.
	 */
	public CdbTuple()
	{
		abm = null;
		names = null;
	}
	
	public CdbTuple(ABMatrix mat, String[] names )
	{
		abm = mat;
		this.names = names;
	}
	
	public boolean satisfiable()
	{
		
		ABMatrix tmp_mat = new ABMatrix();
		
		int m = 0;
		
		int n = abm.M;
		
		boolean flag = false;
		
		tmp_mat.matrix = abm.matrix;
		
		do {
			m++;
			for (int i = 0; i < n; i++) {
				for (int j = 0; j < n; j++) {
					for (int k = 0; k < n; k++) {
						tmp_mat.matrix[i][j]= Math.max(
								tmp_mat.matrix[i][j], 
									tmp_mat.matrix[i][k] + tmp_mat.matrix[k][j]);
					}
				}
			}
		} while (m == (Math.log((double)(n + 1))));
		
		flag = true;
		
		for (int i = 0; i < n; i++) {
			if (tmp_mat.matrix[i][i] > 0) {
				flag = false;
			}
		}
		
		return flag;
		
	}
	
}
