/*
 * Main.java
 *
 * Created on April 1, 2007, 8:45 PM
 *
 * Creates addition constraint matrices and sends to  
 * CdbTuple for satisfiability testing.
 */

package csce913proj1;

/**
 *
 * @author John R. Hodges
 */
public class Main {
    
    /** Creates a new instance of Main */
    public Main() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        ABMatrix m = new ABMatrix();        // +/- constraint matrix
        ABMatrix posm = new ABMatrix();     // +/+ constraint matrix
        ABMatrix negm = new ABMatrix();     // -/- constraint matrix
        m.matrix = new double[5][5];
        posm.matrix = new double[5][5];
        negm.matrix = new double[5][5];
        
        // Initialize matrices with positive infinity weights
        for (int i=0; i<5; i++) {
            for (int j=0; j<5; j++) {
            m.matrix[i][j] = Double.POSITIVE_INFINITY;
            posm.matrix[i][j] = Double.POSITIVE_INFINITY;
            negm.matrix[i][j] = Double.POSITIVE_INFINITY;
            }
        }
        
//         Set of SATISFIABLE addition constraints
        m.matrix[2][3] = 10;    // -x+y <= 10
        m.matrix[4][2] = -5;    //  x-z <= -5
        m.matrix[0][1] = 0;     //    w <= 0
        m.matrix[1][0] = 3;     //   -w <= 3
        posm.matrix[1][2] = 6;  //  w+x <= 6
        negm.matrix[4][3] = 0;  // -y-z <= 0
        
        // Set of UNSATISFIABLE addition constraints
//        m.matrix[4][2] = -3;    // x-z <= -3
//        m.matrix[4][3] = 8;     // y-z <= 8
//        m.matrix[3][1] = 2;     // w-y <= 2
//        m.matrix[2][1] = -4;    // w-x <= -4
//        m.matrix[1][0] = -40;   // -w <= -40
//        m.matrix[0][4] = 20;    // z <= 20
        
        m.M = 5;
        posm.M = 5;
        negm.M = 5;
        
        // Remove comments to print working constraint matrices
        //System.out.println("*** Beginning Matrices ***");
        //System.out.println("matrix:");
        //m.printMatrix();
        //System.out.println("\nposMatrix:");
        //posm.printMatrix();
        //System.out.println("\nnegMatrix:");
        //negm.printMatrix();
        //System.out.println("");
        
        CdbTuple t = new CdbTuple(m, posm, negm, new String[] {"0", "w", "x", "y", "z"});
        boolean flag = t.satisfiable();
        
        // Print final +/- matrix after all variables except "0" are eliminated
        System.out.println("*** Ending Matrix ***");
        System.out.println("matrix:");
        m.printMatrix();
        System.out.println("");
        
        if (flag) {
            System.out.println("These constraints ARE satisfiable...");
        } else {
            System.out.println("These constraints ARE NOT satisfiable...");
        }
    }
}
