﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace DGBindingExample
{
    public partial class Form1 : Form
    {
        List<Widget> widgets;
        List<ModelClass> models;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            widgets = Widget.getWidgetList();
            bsWidgets.DataSource = widgets.ToArray();
            models = ModelClass.getModelList(widgets[0]);
            List<ViewModelClass> vModels = new List<ViewModelClass>();
            foreach (ModelClass m in models)
            {
                vModels.Add(new ViewModelClass(m, widgets));
            }
            bsViewModelClass.DataSource = vModels.ToArray();
            
        }

        private void btListModel_Click(object sender, EventArgs e)
        {
            tbModelList.Text = "";
            foreach (ModelClass m in models)
            {
                tbModelList.Text += m.ToString() + "\r\n";
            }
        }
    }
}
