﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DGBindingExample
{
    public class ViewModelClass
    {
        private ModelClass _model;
        private List<Widget> _widgets;

        public string line
        {
            get
            {
                return _model.line;
            }
            set
            {
                _model.line = value;
            }
        }
        public int qty
        {
            get
            {
                return _model.qty;
            }
            set
            {
                _model.qty = value;
            }
        }
        public string widget
        {
            get
            {
                return _model.chosenWidget.name;
            }
            set
            {
                string x = value;
                if (!setValue(x)) throw new Exception("Not a valid Widget!");
            }
        }

        public ViewModelClass(ModelClass m, List<Widget> wl)
        {
            _model = m;
            _widgets = wl;
        }

        private bool setValue(string val)
        {
            if (_widgets == null) return false;
            Widget w = _widgets.Find(x => x.name.Equals(val));
            if (w == null) return false;
            _model.chosenWidget = w;
            return true;
        }

    }
}
