﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace DGBindingExample
{
    public class Widget : IEquatable<Widget>
    {
        public int id { get; set; }
        public double price { get; set; }
        public string name { get; set; }
        public string description { get; set; }

        static public List<Widget> getWidgetList()
        {
            List<Widget> rval = new List<Widget>();
            rval.Add(new Widget() { id = 3, price = 10.80, name = "W", description = "Brand W" });
            rval.Add(new Widget() { id = 0, price = 10.50, name = "X", description = "Brand X" });
            rval.Add(new Widget() { id = 1, price = 10.60, name = "Y", description = "Brand Y" });
            rval.Add(new Widget() { id = 2, price = 10.70, name = "Z", description = "Brand Z" });
            return rval;
        }

        public override bool Equals(object obj)
        {
            if (obj == null || Convert.IsDBNull(obj)) return false;
            return ((Widget)obj).id == this.id;
        }

        public override int GetHashCode()
        {
            return id.GetHashCode();
        }

        public override string ToString()
        {
            return "{" + id + ", " + price + ", " + name + ", " + description + "}";
        }

        public bool Equals(Widget w)
        {
            if (w == null) return false;
            return w.id == this.id;
        }

    }
}
