USE ACMTextbookExample

DROP TABLE ClassRoster;
DROP TABLE StudentAdvisor;
DROP TABLE ClassSection;
Drop Table Student
Drop Table Professor
Drop TABLE CourseListing;

GO

CREATE TABLE CourseListing(
DeptCode			char(4) NOT NULL,
CourseNumber		int NOT NULL,
CourseDescription	varchar(500) NULL,
CONSTRAINT CL_PK PRIMARY KEY (DeptCode, CourseNumber)
);

CREATE TABLE Professor(
ProfessorID			int PRIMARY KEY IDENTITY(1,1),
FirstName			varchar(20) NOT NULL,
MiddleName			varchar(20) NULL,
LastName			varchar(20) NOT NULL,
Degree				varchar(15) NOT NULL
);

CREATE TABLE Student(
StudentID			int PRIMARY KEY IDENTITY(1,1),
FirstName			varchar(20) NOT NULL,
MiddleName			varchar(20) NULL,
LastName			varchar(20) NOT NULL
);

CREATE TABLE ClassSection(
SectionID			int PRIMARY KEY IDENTITY(1,1),
DeptCode			char(4) NOT NULL,
CourseNumber		int NOT NULL,
ProfessorID			int NOT NULL,
SchoolYear			int NOT NULL,
Semester			char(1) NOT NULL,
Section				char(2) NOT NULL,
CONSTRAINT COR_FK FOREIGN KEY (DeptCode, CourseNumber) REFERENCES CourseListing,
CONSTRAINT PRO_FK FOREIGN KEY (ProfessorID) REFERENCES Professor
);

-- Classic Intersection Many-to-Many table
CREATE TABLE StudentAdvisor(
StudentID			int,
ProfessorID			int
CONSTRAINT SA_PK PRIMARY KEY (StudentID, ProfessorID),
CONSTRAINT STSA_FK FOREIGN KEY (StudentID) REFERENCES Student,
CONSTRAINT PFSA_FK FOREIGN KEY (ProfessorID) REFERENCES Professor
);

-- Classic Association Many-to-Many with properties Table
CREATE TABLE ClassRoster(
StudentID			int,
SectionID			int,
Grade				char(2),
CONSTRAINT CR_PK PRIMARY KEY (StudentID, SectionID), 
CONSTRAINT CRST_FK FOREIGN KEY (StudentID) REFERENCES Student,
CONSTRAINT CRSE_FK FOREIGN KEY (SectionID) REFERENCES ClassSection);

-------------------------------------------------------------------------------
-- Sample Data 
-------------------------------------------------------------------------------

SET IDENTITY_INSERT Professor ON

INSERT INTO Professor(ProfessorID, FirstName, LastName, Degree) VALUES(1, 'Nolan', 'Ryan', 'Ph.D.');
INSERT INTO Professor(ProfessorID, FirstName, LastName, Degree) VALUES(2, 'Hank', 'Aaron', 'Ph.D.');

SET IDENTITY_INSERT Professor OFF

SET IDENTITY_INSERT Student ON

INSERT INTO Student(StudentID, FirstName, LastName) VALUES(1, 'Frank', 'Sinatra');
INSERT INTO Student(StudentID, FirstName, LastName) VALUES(2, 'Dean', 'Martin');
INSERT INTO Student(StudentID, FirstName, LastName) VALUES(3, 'Sammy', 'Davis');
INSERT INTO Student(StudentID, FirstName, LastName) VALUES(4, 'Peter', 'Lawford');
INSERT INTO Student(StudentID, FirstName, LastName) VALUES(5, 'Joey', 'Bishop');

SET IDENTITY_INSERT Student OFF

INSERT INTO CourseListing VALUES('CPTR', 319, 'Database Management Systems');

SET IDENTITY_INSERT ClassSection ON

INSERT INTO ClassSection(SectionID, DeptCode, CourseNumber, ProfessorID, SchoolYear, Semester, Section) 
			VALUES(1, 'CPTR', 319, 1, 2012, 'W', 'A');
INSERT INTO ClassSection(SectionID, DeptCode, CourseNumber, ProfessorID, SchoolYear, Semester, Section) 
			VALUES(2, 'CPTR', 319, 2, 2012, 'W', 'B');

SET IDENTITY_INSERT ClassSection OFF

INSERT INTO ClassRoster(StudentID, SectionID) VALUES(1,1);
INSERT INTO ClassRoster(StudentID, SectionID) VALUES(2,1);
INSERT INTO ClassRoster(StudentID, SectionID) VALUES(3,1);
INSERT INTO ClassRoster(StudentID, SectionID) VALUES(4,2);
INSERT INTO ClassRoster(StudentID, SectionID) VALUES(5,2);

INSERT INTO StudentAdvisor VALUES(1,1);
INSERT INTO StudentAdvisor VALUES(2,1);
INSERT INTO StudentAdvisor VALUES(3,1);
INSERT INTO StudentAdvisor VALUES(3,2);
INSERT INTO StudentAdvisor VALUES(4,2);
INSERT INTO StudentAdvisor VALUES(5,2);