﻿using System;
using System.Linq;
using FrameworkDataModel;

namespace Demo2
{
    class Program
    {
        private static ACMFrameworkExampleEntities _context;

        static void Main(string[] args)
        {
            //Create a new Entity Framework Context
            _context = new ACMFrameworkExampleEntities();

            //Populate context with student "Dean Martin"
            Student Dean = _context.Students.Where(x => x.FirstName.Equals("Dean")).First();

            Console.WriteLine("Dean is now in " + Dean.ClassRosters.First().ClassSectionName + ".");
            ClassRoster csr = Dean.ClassRosters.Where(x => x.StudentID == Dean.StudentID).First();

            //Move Dean Martin to Section B (SectionID = 2)
            //Here we do have access to the ID's so we should be able to just change that!
            try
            {
                csr.SectionID = 2;
                Console.WriteLine("Dean is now in " + Dean.ClassRosters.First().ClassSectionName + ".");
            }
            catch (Exception e)
            {
                Console.WriteLine("*** ERROR: " + e.Message + " ***");
            }
        }
    }
}
