﻿using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using EF_WPF_Example.Annotations;

namespace EF_WPF_Example
{
    class MainViewModel : INotifyPropertyChanged
    {
        private readonly UniversityExampleEntities _context = new UniversityExampleEntities();
        private readonly List<student> _students;
        private readonly DelegateCommand _prev;
        private readonly DelegateCommand _next;
        private readonly DelegateCommand _save;


        private int _index;
        private readonly int _maxIndex;

        public string Name
        {
            get { return _students[_index].name; } 
            set
            {
                _students[_index].name = value;
                OnPropertyChanged("Name");
            }
        }

        public string Department
        {
            get { return _students[_index].dept_name; }
            set
            {
                _students[_index].dept_name = value;
                OnPropertyChanged("Department");
            }
        }

        public List<take> Classes
        {
            get { return _students[_index].takes.ToList(); }
        }

        public DelegateCommand Prev
        {
            get { return _prev; }
        }

        public DelegateCommand Next
        {
            get { return _next; }
        }

        public DelegateCommand Save
        {
            get { return _save; }
        }

        public MainViewModel()
        {
            _students = _context.students.Include("takes").ToList();
            _index = 0;
            _maxIndex = _students.Count() - 1; 
            _next = new DelegateCommand(MoveNext, x=>_index < _maxIndex);
            _prev = new DelegateCommand(MovePrev, x=>_index > 0);
            _save = new DelegateCommand(x=>_context.SaveChanges(), x=>true);
        }

        private void MoveNext(object o)
        {
                _index++;
                NotifyAll();
                Prev.CanExecute(null);
                Next.CanExecute(null);
        }

        private void MovePrev(object o)
        {
                _index--;
                NotifyAll();
                Prev.CanExecute(null);
                Next.CanExecute(null);
        }

        private void NotifyAll()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs("Name"));
                PropertyChanged(this, new PropertyChangedEventArgs("Department"));
                PropertyChanged(this, new PropertyChangedEventArgs("Classes"));
                PropertyChanged(this, new PropertyChangedEventArgs("Next"));
                PropertyChanged(this, new PropertyChangedEventArgs("Prev"));
                PropertyChanged(this, new PropertyChangedEventArgs("Save"));
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        [NotifyPropertyChangedInvocator]
        protected virtual void OnPropertyChanged(string property)
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(property));
        }
    }
}
