package com.example.cbdiary;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import com.example.data.MyDB;

public class Diary extends Activity {

	EditText titleET, contentET;
	Button submitBT;
	MyDB dba;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.diary);
		dba = new MyDB(this);
		dba.open();
		titleET = (EditText)findViewById(R.id.diarydescriptontext);
		contentET = (EditText)findViewById(R.id.diarycontenttext);
		submitBT = (Button)findViewById(R.id.submitbutton);
		submitBT.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				try {
					saveItToDB();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
	
	public void saveItToDB() {
		dba.insertDiary(titleET.getText().toString(), contentET.getText().toString());
		dba.close();
		titleET.setText("");
		contentET.setText("");
		Intent i = new Intent(Diary.this, DisplayDiaries.class);
		startActivity(i);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// Handle action bar item clicks here. The action bar will
		// automatically handle clicks on the Home/Up button, so long
		// as you specify a parent activity in AndroidManifest.xml.
		int id = item.getItemId();
		if (id == R.id.action_settings) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}
}
