﻿using DeleteMe.ViewModels.Base;
using System.Threading.Tasks;

namespace DeleteMe.ViewModels
{
    public class ParameterizedViewModel : ViewModelBase
    {
        private string _MyMessage;
        public string MyMessage
        {
            get
            {
                return _MyMessage;
            }
            set
            {
                SetValue<string>(ref _MyMessage, value);
            }
        }

        public ParameterizedViewModel()
        {
            _MyMessage = "No Parameter Set.";
        }

        /// <summary>
        /// Example of passing an object parameter
        /// </summary>
        /// <param name="navigationData"></param>
        /// <returns></returns>
        public override Task InitializeAsync(object navigationData)
        {
            MyMessage = (string)navigationData;
            return Task.CompletedTask;
        }
    }
}
