﻿using DeleteMe.Services;
using System;
using System.Runtime.CompilerServices;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace DeleteMe.ViewModels.Base
{
    public abstract class ViewModelBase : BindableObject 
    {
        protected readonly INavigationService NavigationService;


        private bool _isBusy;
        public bool IsBusy
        {
            get
            {
                return _isBusy;
            }
            set
            {
                SetValue(ref _isBusy, value);
            }
        }

        public ViewModelBase()
        {
            NavigationService = ViewModelLocator.Resolve<INavigationService>();

            #region Additional Services 
            // Below is a set of services that you may want to add to a Xamarin App that uses:
            //  * The ability to invoke a simple dialog using a service 
            //  * appsettings.json
            //  * Settings relevant to IdentityServer4
            //  * We should also include some sort of logging service. 
            /*
            DialogService = ViewModelLocator.Resolve<IDialogService>();
            var settingsService = ViewModelLocator.Resolve<ISettingsService>();
            GlobalSetting.Instance.BaseIdentityEndpoint = settingsService.IdentityEndpointBase;
            GlobalSetting.Instance.BaseGatewayShoppingEndpoint = settingsService.GatewayShoppingEndpointBase;
            GlobalSetting.Instance.BaseGatewayMarketingEndpoint = settingsService.GatewayMarketingEndpointBase;
            */
            #endregion
        }

        public virtual Task InitializeAsync(object navigationData)
        {
            return Task.FromResult(false);
        }

        #region - Moved ExtendedBindableObject method here since we don't do that much in it - too deep of a hierarchy. 

        public void SetValue<T>(ref T field, T value, [CallerMemberName] string propertyName = null)
        {
            try
            {
                if (!field.Equals(value))
                {
                    field = value;
                    OnPropertyChanged(propertyName);
                }
            }
            catch (Exception)
            {  
                //TODO: add a log entry instead of throwing an exception.
                throw new Exception("Error in ViewModelBase Object - Did you try to set a public property in the constructor?");
            }
        }

        #endregion
    }
}
