﻿using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.CompilerServices;
using BibleBeliefs.Database;

namespace BibleBeliefs.ViewModels
{
    public class MainViewModel : INotifyPropertyChanged
    {
        private BibleBeliefsContext context;
        public MainViewModel()
        {
            context = new BibleBeliefsContext();
            Topics = context.Topics.OrderBy(x => x.Topic).ToList();
            SelectedTopic = Topics[0];
        }

        private List<Topics> _Topics; 
        public List<Topics> Topics
        {
            get
            {
                return _Topics;
            }
            set {
                SetField<List<Topics>>(ref _Topics, value);
            }
        }

        private Topics _SelectedTopic;
        public Topics SelectedTopic
        {
            get { return _SelectedTopic; }
            set 
            {
                SetField<Topics>(ref _SelectedTopic, value);    
                Beliefs = context.Beliefs.Where(x => x.TopicId == _SelectedTopic.Id).ToList(); //This will cause Beliefs to be updated too!
            } 
        }

        private List<Beliefs> _Beliefs;
        
        public List<Beliefs> Beliefs 
        {
            get
            {
                return _Beliefs;
            }
            set
            {
                SetField<List<Beliefs>>(ref _Beliefs, value);
            }
        }

        #region INPC

        public event PropertyChangedEventHandler PropertyChanged;

        protected void SetField<T>(ref T field, T value, [CallerMemberName] string propertyName = null)
        {
            field = value;
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }

        #endregion
    }
}
