function Import-509Certificate {
    param([String]$certPath, [String]$certRootStore, [String]$certStore)
    
    Write-Host $certPath
    Write-Host $certRootStore
    Write-Host $certStore
    $pfx = New-Object System.Security.Cryptography.X509Certificates.X509Certificate2
    $pfx.import($certPath)
    
    $store = New-Object System.Security.Cryptography.X509Certificates.X509Store($certStore, $certRootStore)
    $store.open("MaxAllowed")
    $store.add($pfx)
    $store.close()
}

Import-509Certificate ".\vmhost01.cer" "LocalMachine" "root"
Import-509Certificate ".\vmhost02.cer" "LocalMachine" "root"
Import-509Certificate ".\vmhost03.cer" "LocalMachine" "root"
Import-509Certificate ".\vmhost04.cer" "LocalMachine" "root"
Import-509Certificate ".\Og.cer" "LocalMachine" "root"
Import-509Certificate ".\joab.cer" "LocalMachine" "root"
Import-509Certificate ".\samuela.cer" "LocalMachine" "root"
Import-509Certificate ".\samuelb.cer" "LocalMachine" "root"